//===============================================================================================
// Defines common payment transition entries
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

//-----------------------------------------------------------------------------------------------
// Unlock transition map
//-----------------------------------------------------------------------------------------------
var kUnlockTransitions = new Array(
								
	// Unlock online branch
	new zTransitionMap( "connecting.htm?unlock", new Array(
									new zTransitionMapItem( "next", null, "actConnect?unlock" )
								)),

	new zTransitionMap( "actConnect?unlock", new Array(
									new zTransitionMapItem( "ok",			"unlockProdKey.htm?online" ),
									new zTransitionMapItem( "failed",	"unlockConnectionFailed.htm" )
								)),

	new zTransitionMap( "unlockConnectionFailed.htm", new Array(
									new zTransitionMapItem( "connectNow",		"connecting.htm?unlock" ),
									new zTransitionMapItem( "connectLater",	null, "actConnectLater" ),
									new zTransitionMapItem( "unlockByPhone",	"unlockByPhone.htm" ),
									new zTransitionMapItem( "back",				"unlockSelection.htm" )
								)),

	new zTransitionMap( "unlockProdKey.htm?online", new Array(
									new zTransitionMapItem( "next",	"unlocking.htm?unlockonly" ),
									new zTransitionMapItem( "back",	"unlockSelection.htm" )
								)),

	new zTransitionMap( "unlocking.htm", new Array(
									new zTransitionMapItem( "next", null, "actUnlock" )
								)),

	new zTransitionMap( "unlocking.htm?unlockonly", new Array(
									new zTransitionMapItem( "next", null, "actUnlockOnly" )
								)),

	new zTransitionMap( "actUnlock", new Array(
									// Eat errors...
									new zTransitionMapItem( "ok",					"unlocked.htm" ),
									new zTransitionMapItem( "tryAgain",			null, "actUnlock" ),
									new zTransitionMapItem( "needsPurchase",	"unlockNeedsPurchase.htm" ),
									new zTransitionMapItem( "failed",			"unlockFailed.htm" )
								)),

	new zTransitionMap( "unlockNeedsPurchase.htm", new Array(
									new zTransitionMapItem( "buyOnline",	"myCDPriorityCode.htm?online" ),
									new zTransitionMapItem( "buyByPhone",	"myCDPriorityCode.htm?phone" ),
									new zTransitionMapItem( "back",			"unlockOrPurchase.htm" )
								)),

	new zTransitionMap( "unlockFailed.htm", new Array(
									new zTransitionMapItem( "tryAgain",			"connecting.htm?unlock" ),
									new zTransitionMapItem( "unlockByPhone",	"unlockByPhone.htm" ),
									new zTransitionMapItem( "unlockLater",		null, "actUnlockLater" )
								)),


	// Unlock by phone branch
	new zTransitionMap( "unlockProdKey.htm?phone", new Array(
									new zTransitionMapItem( "next",	"unlockByPhone.htm" ),
									new zTransitionMapItem( "back",	"unlockSelection.htm" )
								)),
								
	new zTransitionMap( "unlockByPhone.htm", new Array(
								new zTransitionMapItem( "next", "unlocked.htm" ),
								new zTransitionMapItem( "back", "unlockProdKey.htm?phone" )
							)),


// Unlock common
	new zTransitionMap( "unlocked.htm", new Array(
								new zTransitionMapItem( "ok", null, "actDone" )
							))
);


//-----------------------------------------------------------------------------------------------
// Method to append common transition the concrete transition map
//-----------------------------------------------------------------------------------------------
function appendUnlockTransitions( sequence )
	// Add the buy online sequence to the specified map.
	// fromPage specifies the page name prior to this sequence.
	// toPage specifies the page to go to upon completion
{
	if(!sequence)return;
	
	// Add the items into the main map
	var srcCnt = kUnlockTransitions.length;
	
	for( var i=0; i<srcCnt; ++i ) sequence.maps[sequence.mapCnt++]=kUnlockTransitions[i];
}
